#!/usr/bin/perl
# file: DirectUndo.cgi

#    Copyright (C) 1998,1999,2000 by Data EXchange Associates, Inc.
# 
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
# Data EXchange Associates, Inc.
# 230 Burnt Meadow Road			email: support@dexa.com
# Groton,  MA  01450			http://www.dexa.com
# Telephone: 978.448.3188 voice
#=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
#

# DirectUndo.cgi restores a previous version of an updated webpage
# (one level undo).

# 
# History:
#  1Jul00 MGiguere GPLed
#  8Sep98 MGiguere Platform independent code added.
# 27Jul98 MGiguere Created.

$VERSION="DirectUndo.cgi Version 2.2";

# include a useful CGI library
require 'cgi-lib.pl';

# include DirectMarkUP library
require 'DirectMarkUP.pl';

# include the DirectMarkUp configuration file
require 'DirectMarkUP.pm';

# get the target HTML file name from the command line
$targetFile = shift @ARGV;
$templateFile = &pathify( $targetFile );
$isURL = &FALSE;
if (! -f $templateFile ) {  # no try as a URL
    $templateFile = &pathify( $docRoot . $targetFile );
    if ( ! -f $templateFile ) {
	CgiError("Error:  ". __FILE__ .":". __LINE__,
		 "Error: could not find the template file: $templateFile."
		 );
	exit 1;
    }
    $isURL = &TRUE;
}

if ( rename( "$templateFile.bak", $templateFile ) == 0 ) {
    CgiError("Error: ". __FILE__ .":". __LINE__,
	     "Error: Unable to restore previous version of $targetFile",
	     );
    exit 1;
}

# update timestamp on file to force server & browser cache update
$now = time;
utime( $now, $now, $templateFile );

&EvtLog( "Restored previous version of $targetFile" );

if ( $isURL ) {
    print "Location: $server$targetFile\n\n";
}
else {
    CgiError( "Success!",
	     "", "Previous version of: $targetFile restored."
	     );
}

exit 0;
