#!/usr/bin/perl
# file: MakeDirectForm

#    Copyright (C) 1998,1999,2000 by Data EXchange Associates, Inc.
# 
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
# Data EXchange Associates, Inc.
# 230 Burnt Meadow Road			email: support@dexa.com
# Groton,  MA  01450			http://www.dexa.com
# Telephone: 978.448.3188 voice
#=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
#

# 
# History:
#  1Jul00 MGiguere GPLed
#  8Sep98 MGiguere Added platfrom independent code.
# 28Jul98 MGiguere Added Undo feature.
# 20Jul98 MGiguere Updated to use DIRECT tags.
# 18Jun98 MGiguere Created.
#

$VERSION="MakeDirectForm Version 2.3, Copyright (c) 1998 by Data EXchange Associates, Inc. as an  unpublished work.  All rights reserved.";

# include the DirectMarkUP global definitions needed by this script
require 'DirectMarkUP.pl';
require 'DirectMarkUP.pm';
require 'HTMLParser.pm';

# default number of columns for input box & text area
$minCols = 20;

$USAGE="Usage: $0 webpage >updatepage\n";

$#ARGV < 0 and die $USAGE;

# get the URL of the target file
$targetFile = shift @ARGV;

open TFILE, &pathify( $docRoot . $targetFile ) or die "Error: couldn't open file: $targetFile\n";

# read in entire the target file in one gulp
{
    local $/ = undef;
    $template = <TFILE>;
    close TFILE;
}

$p = new HTMLParser( $template );
$template = null;
$tagList = $p->{'tags'};
$count = @$tagList;
@stags = ();
@etags = ();
@tagInfo = ();
@textList = ();
%dups = ();

#gather collections of DIRECT & /DIRECT tags
for ( $i = 0; $i < $count; $i++ ) {
    $t = @$tagList->[ $i ];
    if (($t->{type} =~ /^starttag/) and ($t->{content} =~ /^DIRECT/i)) {
	push( @stags, $i );
    }
    elsif (($t->{type} =~ /^endtag/) and ($t->{content} =~ /^\/DIRECT/i)) {
	push( @etags, $i );
    }
}

( @$stags == @$etags ) or die "Error: DIRECT and /DIRECT tags not balanced\n";

# scan each DIRECT /DIRECT tag range for text 
for ( $i = 0; $i < @stags; $i++ ) {
#compute range
    $a = ( @stags[ $i ] ) + 1;
    $b = ( @etags[ $i ] ) - 1;
    $found = null;
# scan return tags for a text item
    foreach $t ( @$tagList[ $a..$b ] )  {
	if ( $t->{type} =~ /text/ ) {
	    $found = $t;
	    last;
	}
    }
    push( @textList, $found );
}

# DirectInfo structure:
# { 'type' => INPUT | TEXTAREA,
#   'name' => <str from DIRECT NAME field>,
#   'label'=> <test from DIRECT LABEL field>,
#   'geom' =>  ( COLS=n | ROWS=n COLS=m ),
# }

# for every DIRECT tag construct a list entry with a DirectInfo structure

foreach $i ( 0..( @stags - 1 )) {
    $type = "INPUT";
    $geom = "";
    $rows = 1;
    $cols = 0;

    $t = @textList[ $i ];
    if ( $t != null ) {
	@lines = split(  /\n/, $t->{content} );
	$rows = @lines;
	foreach $l ( @lines ) {
	    $c = length $l;
	    if ( $c > $cols ) {
		$cols = $c;
	    }
	}
    }
    else {
	$cols = $minCols;
    }

    if ( $rows > 1 ) {
	$type = "TEXTAREA";
	$geom = " ROWS=$rows COLS=$cols ";
    }
    else {
	$geom = " TYPE=text SIZE=$cols MAXLENGTH=$cols";
    }
    %atts = $p->attList( @$tagList[ @stags[ $i ]]->{content} );
    push ( @tagInfo, { 'type' => $type,
		       'name' => %atts->{name},
		       'label'=> %atts->{label},
		       'geom' => $geom,
		   }
	  );
}

print "<HTML>\n";
print "<HEAD>\n";
print "<META NAME=\"GENERATOR\" CONTENT=\"DirectMarkUP 2.0 Linux/Unix\">\n";
print "<TITLE>DirectMarkUP Update page for: $targetFile</TITLE>\n";
print "</HEAD>\n";
print "<BODY BGCOLOR=\"#ffffff\">\n\n";
print "<FORM ACTION=\"$actionURL/DirectMarkUP.cgi?$targetFile\" METHOD=\"POST\" ENCTYPE=\"x-www-form-urlencoded\">\n";
print "<FONT SIZE=8>\n";
print "<P><CENTER>Changes for page: $targetFile</CENTER></P>\n";
print "</FONT>\n";
print "<P><CENTER>&nbsp;</CENTER></P>\n";

print "<P><CENTER><HR WIDTH=600></CENTER></P>\n";

# put the DirectMarkUP input fields into the window
foreach $tag ( @tagInfo ) {
    if ( ! %dups->{$tag{name}} ) {
	print "<P><CENTER><FONT SIZE=\"+1\">$tag->{label}</FONT></CENTER></P>\n";
	print "<CENTER>\n";
	print ( "<", $tag->{type},
	       " NAME=", $tag->{name},
	       $tag->{geom}, ">",
	       "</", $tag->{type}, ">\n"
	       );
	print "</CENTER>\n\n";
    }
    else {
	$dups{$tag->{name}} = 1;
	print STDERR "Duplicate DIRECT tag: ". $tag->{name}. " skipping\n";
    }
}

print "<P><CENTER><HR WIDTH=600></CENTER></P>\n";

print "<P><CENTER><INPUT TYPE=\"submit\" VALUE=\"Do Change Now\" >\n";
print "<INPUT TYPE=\"reset\" VALUE=\"Clear Form\"></CENTER></P></FORM>\n";
print "<P><CENTER>&nbsp;</CENTER></P>\n";
print "<FORM ACTION=\"$actionURL/DirectUndo.cgi?$targetFile\" METHOD=\"POST\" ENCTYPE=\"x-www-form-urlencoded\">\n";
print "<P><CENTER><INPUT TYPE=\"submit\" VALUE=\"UnDo Change\" ></P>\n";
print "</FORM>\n";
print "</BODY>\n";
print "</HTML>\n";

exit 0;
