#!/usr/bin/perl
# Copyright (c) 1998,1999,2000 by Data EXchange Associates, Inc. as an
# unpublished work.  All rights reserved.
#
#=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
# Data EXchange Associates, Inc.
# 230 Burnt Meadow Rd.			email: dexa@dexa.com
# Groton,  MA  01450			http://www.dexa.com
# Telephone: 978.448.3188 voice
#            978.448.3216 FAX
#=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
#

# FormFiler.cgi extracts fields from a FORM and appends the
# values to a delimited text file.  The contents of the text file may
# then be used as input to various tools, databases filters...

# FormFiler.cgi accepts one parameter, the name of the form configuration
# file to read for this form.
# Example:
#      <FORM ACTION="/cgi-bin/FormFiler.cgi?config-file">

# History:
# 30Mar99 MGiguere Added feature to do additional processing of data.
# 23Nov98 MGiguere Strip CR's from fields.
# 11Nov98 MGiguere File Locking added.
#  2Nov98 MGiguere Created.
#

$VERSION = 'FormFiler.cgi version 3.0';

# include local functions
require 'FormFiler.pl';

# include File Control package
use Fcntl; 
use FileHandle;

$FormName = pathify( shift @ARGV ); 

require $FormName or die "could not open $FormName config. file";

ReadParse();

unless ( %in ) {
    CgiError("Error: ". __FILE__ .":". __LINE__,
	     "Error: No input found in the form."
	     );
    exit 1;
}

# check for an extract list


if ( @extractlist ) {
    $extList = 1;
}
else {
    @extractlist = keys( %in );
    $extList = 0;
}

# scan FORM input to be sure all the required fields are present
foreach $name ( @required ) {
    $value = $in{$name};
    if ( ( exists( $in{$name} )) && ( length($value) > 0 )) {
	next;
    }
    else {
	push( @errors, "Missing required field: $name" );
    }
}

if ( defined @errors ) {
    CgiError("Error: Missing Input",
	     "", @errors, "",
	     "Please return to the form and try again.",
	     "Thank you."
	     );
    unlink( $lockFile );
    exit 1;
}

# if no output file skip this step and go on
if ( $outputfile ) {
# if no separators defined by user set defaults
    $FS = ( $FS ? $FS : ',' );
    $RS = ( $RS ? $RS : "\n" );

    $lockFile = "$formName.Lock";

    while ( ! sysopen( LOCK, $lockFile, (O_RDWR|O_CREAT|O_EXCL))) {
	sleep( $wait );
	if ( $retries-- < 1 ) {
	    CgiError("Warning: could not lock data file.",
		     "", "Please try agian."
		     );
	    exit 1;
	}
    }

# write our process ID to the Lock file for later use
    print LOCK "$$\n";
    close LOCK;

    unless ( open( OFILE, ">>$outputfile" )) {
	CgiError("Error: ". __FILE__ .":". __LINE__,
		 "Error: could not open output file: $outputfile"
		 );
	unlink( $lockFile );
	exit 1;
    }

    $delimiter = "";

    foreach $name ( @extractlist ) {
	$value = $in{$name};
	# replace carriage control chars. w/space
	$value =~ s/(\r|\n)/ /g;
	print OFILE $delimiter;
	if ( $extList ) {
	    print OFILE ($quoted?'"':"").$value.($quoted?'"':"");
	}
	else {
	    print OFILE $name."=".($quoted?'"':"").$value.($quoted?'"':"");
	}
	$delimiter = $FS;
    }

    print OFILE $RS;
    close OFILE;

# clear the lock before we go
    unlink( $lockFile );

    &EvtLog ( "$ENV{REMOTE_ADDR}" );

# jump to response page if specified
    if ( $jumpTo ) {
	print "Location: $jumpTo\n\n";
    }
    else {
	if ( $Message ) {
	    CgiError( $Message );
	}
    }
}

# If a task list is defined we will perform those operations in
# addition to the default storage of the form data.

if (! defined( $tasks[0] ) ) {
    exit 0;
}

#build a URL encoded package of all the FORM data for tasks.
$data = "";
foreach $key ( keys %in ) {
    $data = $data . "$key=" . &URLEncode( $in{ $key } ) . "&";
}
$ENV{ 'CONTENT_LENGTH' } = length( $data );

# now run each task listed in the $tasks list
foreach $task ( @tasks ) {
    ($cmd, $args) = split( / /, $task, 2 );  #get command and args
    if ( ! -x $cmd ) {
	print STDERR "ERROR:" . __FILE__ . ":". __LINE__ . ": Command: $cmd not found or not executable\n";
	exit 1;
    }
    unless ( open( TASK, "|$task" )) {
	print STDERR "ERROR:". __FILE__ . ":" . __LINE__ . ": Could not fork $task : $!\n";
	exit 1;
    }
    TASK->autoflush();
    print TASK $data;
    close TASK;
}

exit 0;

