# Copyright (c) 1998,1999,2000 by Data EXchange Associates, Inc. as an
# unpublished work.  All rights reserved.
#
#=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
# Data EXchange Associates, Inc.
# 230 Burnt Meadow Road			email: dexa@dexa.com
# Groton,  MA  01450			http://www.dexa.com
# Telephone: 978.448.3188 voice
#            978.448.3216 FAX
#=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
#

# This file contains library functions  used to by the DirectPress.cgi
# script

# History:
# 2Nov98  MGiguere Created.
#

require 'cgi-lib.pl';

# Boolean value definitions:
$false = $False=0;
$true = $True=1;

sub TRUE { $True }
sub FALSE { $False }

# set the platform specific pathname separator character
# Check for backward DOS/NT systems
if ( $^O =~ (/nt/i|/win/i) ) {
    $pps = "\\";
}
else {
    $pps = '/';
}

# Name of the month abbrevations
@mnames = ('Jan', 'Feb', 'Mar', 'Apr',
	   'May', 'Jun', 'Jul', 'Aug',
	   'Sep', 'Oct', 'Nov', 'Dec' );

sub EvtLog {
# EvtLog.  Reads an optional list of messages and appends it to the
# event log file $logFile along with a timestamp.  If no message
# is supplied only the timestamp is output.
# Returns $True for success.  On failure bail out completely.
# If $logFile is undefined just do nothing and return.
# local variables:
local (@msg) = @_;
local ( $item, $timestamp);

# This is how to do conditional compilation in perl
# if $logFile is undefined logging is disabled
if (  defined $logFile ) { eval <<'EndOfEval';

($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime(time);
$timestamp = sprintf("%0.2d:%0.2d:%0.2d:%0.2d%s%0.2d:",
		     $hour, $min, $sec, 
		     $mday, $mnames[$mon], $year );

unless ( open( LOGFILE, ">>". &pathify( $logFile ) ) ) {
    CgiError("Error: ". __FILE__ .":". __LINE__,
	     "Error: could not create or open log file: $logFile" );
# this is a catastrophe bail out fast
    exit 1;
}

print LOGFILE $timestamp;

# print each line in the message to log file
foreach $line ( @msg ) {
    print LOGFILE "$line\n";
}

# no messages, just print timestamp
if ( !@msg ) {
    print LOGFILE "\n";
}

close LOGFILE;

EndOfEval

}


}


# shamelessly ripped off from CGI.pm, by Lincoln D. Stein and modified
# convert a string to a URL encoded string.
sub URLEncode {
    my $toencode = shift;
    $toencode =~s/([^a-zA-Z0-9_\ \-.])/uc sprintf("%%%02x",ord($1))/eg;
    $toencode =~s/ /\+/g;
    return $toencode;
}



# These functions obviate the need to call OS specific
# utilities making FormFiler platform independent.

# copy a file from source (src) to destination (dest)
# returns 0 for failure, number of bytes copied for success.

sub copyFile {

    my( $src, $dest ) = @_;
    my( $total );
    open( S, "<$src" ) || return 0;
    open( D, ">$dest" ) || return 0;

    my $block = '';

    while( ( $s = sysread( S, $block, 2048 ))) {
	$total += $s;
	if ( ! syswrite( D, $block, $s )) {
	    return 0;
	};
    }
    close( S );
    close( D );
    return $total;
}

# move file from source (src) to destination (dest)
# returns 0 for failure, number of bytes moved for success.

sub moveFile {

    my($src, $dest) = @_;

    if ( ($s = &copyFile( $src, $dest )) ) {
	unlink $src;
	return $s;
    }
    else {
	return 0;
    }
}

# pathify - Assure pathname separators are proper for host system.
# NT vs. LINUX/UNIX family

sub pathify {
    my( $path ) = shift;

    if ( $^O =~ /(linux|unix|bsd|solaris)/i ) { 
	$path =~ s|\\|$pps|g;     # UNIX/LINUX family path seps
    }
    else {
	$path =~ s|\/|$pps|g;     # NT path seps
    }
    return $path;
}

return 1;
