#!/usr/bin/perl
# Copyright (c) 1998,1999,2000 by Data EXchange Associates, Inc. as an
# unpublished work.  All rights reserved.
#
#=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
# Data EXchange Associates, Inc.
# 509 Longley Road			email: dexa@dexa.com
# Groton,  MA  01450			http://www.dexa.com
# Telephone: 978.448.3188 voice
#            978.448.3216 FAX
#=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
#

# FormHarvest.cgi is intended to work in conjunction with
# FormFiler.cgi.  FormHarvest.cgi renames the specified file and mails
# it to the address spcified.  Renaming the input file forces
# FormFiler.cgi to begin a new data file.  FormHarvest.cgi requires
# "read" access to the files it is to process.

# FormHarvest uses the following INPUT fields form the
# HTML FORM.  These fields may be of type TEXT or HIDDEN.
#
# Required
# Fields       Meaning
# to           The email address to receive the processed file.
# harvest      The path to the file to read and send.
#
#****************************************************************
#
#        !!!       S E C U R I T Y  W A R N I N G      !!!
#
# It is NOT recommended that you allow users to enter/change/modify
# the values of the "to" and "harvest" fields.  Making these fields
# changeable would allow unprecedented access to the files on your
# website.  Keep these fields HIDDEN for security.
#
#****************************************************************
#
# Optional
# Fields       Meaning
# from         The email address of the sender the default is
#              the webmaster (See FormHarvest.pm $admin)
# subject      A subject line for the mail message.  The default
#              is the filename and the date.
#
# Examples:
#    <INPUT NAME=to TYPE="TEXT" VALUE="somebody@someplace.com">
#    <INPUT NAME=harvest TYPE="HIDDEN" VALUE="../myDB.db">
#
# History:
# 11Nov98 MGiguere File locking added.
#  9Nov98 MGiguere Created.
#

$VERSION = 'FormHarvest.cgi version 1.2';

# include local functions
require 'FormFiler.pl';

# include FormHarvest global definitions
use FormHarvest;

# include File Control package
use Fcntl;

# read input values from the FORM

ReadParse();

# test to see if we got any input before anything else
unless ( %in ) {
    CgiError("Error: ". __FILE__ .":". __LINE__,
	     "Error: No input found in the form."
	     );
    exit 1;
}

# We must have a destination email address!
unless ( $To = $in{'to'} ) {
    CgiError("Error: ". __FILE__ .":". __LINE__,
	     "Error: no \"to\" field found in FORM data.",
	     "Don\'t know where to send data?"
	     );
    exit 1;
}

($sec,$min,$hour,$day,$mon,$year,$wday,$yday,$isdst) = localtime();
$year += 1900;

if ( ++$mon < 10 ) {
    $mon = "0$mon";
}
if ( $day < 10 ) {
    $day = "0$day";
}

# set the email address of the Sender

unless ( $From = $in{'from'} ) {
    $From = $admin;
}

unless ( $harvest = pathify( $in{'harvest'} )) {;
    CgiError("Error: ". __FILE__ .":". __LINE__,
	     "Error: no \"harvest\" file in form data."
	     );
    exit 1;
}

# if no subject use the default Subject line
unless ( $Subject = $in{'subject'} ) {
    $Subject = "Harvested: $in{'harvest'} on: $mon/$day/$year";
}

# new name for the data file

$newFile = "$harvest.$year$mon$day";

$lockFile = "$harvest.Lock";

while ( ! sysopen( LOCK, $lockFile, (O_RDWR|O_CREAT|O_EXCL))) {
    sleep( $wait );
    if ( $retries-- < 1 ) {
	CgiError("Warning: could not lock data file.",
		 "", "Please try agian."
		 );
	exit 1;
    }
}

# write our process ID to the Lock file for later use
print LOCK "$$\n";
close LOCK;

# this where we take the snapshot of the data file

# open the file to harvest
unless ( open( IFILE, "$harvest" )) {
    CgiError("Error: ". __FILE__ .":". __LINE__,
	     "Error: could not open input file: $harvest"
	     );
    unlink( $lockFile );
    exit 1;
}

# read in entire the target file in one gulp
{
    local $/ = undef;
    $data = <IFILE>;
    close IFILE;
}

# Open a pipe to the mailer

unless ( open( MAILER, "|$mailer $mailerOpts" ) ) {
    CgiError("Error: ". __FILE__ .":". __LINE__,
	     "Error: could not open: $mailer"
	     );
    unlink( $lockFile );
    exit 1;
}

# compose the mail headers

print MAILER "To: $To\n";
print MAILER "From: $From\n";

# send subject and end mail header

print MAILER "Subject: $Subject\n\n";

# now send the body of the data file

print MAILER $data;
print MAILER "\n\n";
close MAILER;

# NOTE new data is ALWAYS appended to the backup file for saftey.
# This assures that all data for a day will be saved somewhere.

unless( open( OFILE, ">>$newFile" )) {
    CgiError("Error: ". __FILE__ .":". __LINE__,
	     "Error: could not open input file: $newFile"
	     );
    close IFILE;
    unlink( $lockFile );
    exit 1;
}
# save the data in the backup file
print OFILE $data;
close OFILE;
unlink( $harvest );
unlink( $lockFile );

CgiError("Success",
	 "The file $harvest has been mailed to: $To",
	 "Thank you."
	 );

exit 0;
