#!/usr/bin/perl
# file: MailNotifier.pl

#    Copyright (C) 1999,2000  Data Exchange Associates, Inc.
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
# Data EXchange Associates, Inc.
# 230 Burnt Meadow Road			email: support@dexa.com
# Groton,  MA  01450			http://www.dexa.com
# Telephone: 978.448.3188 voice
#=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
#

# Description

# MailNotifier is a simple agent that takes its input from WebSitter.pl
# then uses Sendmail to deliver its report on a website to the webmaster.
# Note the first line read is assumed to be the Subject line for the message.

# 
# History:
# 16Mar99 MGiguere Created.

$VERSION="MailNotifier.pl Version 1.5";

use MailNotifier;

$subject = "";

unless ( -x $mailer ) {
    print "Error: ". __FILE__ . ":". __LINE__ ." Could not find: $mailer\n";
    exit 1;
}

open( MAILER, "|$mailer $mailerArgs" ) || die  "Error: could not open: $mailer: $!";

# compose the mail message

while ( $line = <> ) {

local $SIG{PIPE} = sub { die "$mailer pipe broke" };

# compose message header
    if ( ! $subject ) {
	$subject = $line;
	print MAILER "To: $To\n";
	print MAILER "From: $From\n";
	print MAILER "Subject: $subject\n";
    }
    else {
# send body
	print MAILER "$line";
    }
}

print MAILER "\n\n";
close MAILER;
