#!/usr/bin/perl
# file: WebSitter.pl

#    Copyright (C) 1999,2000  Data Exchange Associates, Inc.
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
# Data EXchange Associates, Inc.
# 230 Burnt Meadow Road			email: support@dexa.com
# Groton,  MA  01450			http://www.dexa.com
# Telephone: 978.448.3188 voice
#=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
#

# Description

# 
# History:
#  6Jul99 MGiguere Send notification on can't connect.
# 17Mar99 MGiguere Notfication now modularized.
# 11Mar99 MGiguere Added code to retry on "Bad Request" error.
#  9Feb99 MGiguere Created.

$VERSION="WebSitter.pl Version 1.5";

use Socket;
use IO::Handle;
use WebSitter;

if ( @ARGV < 1 ) {
    print "Usage: $0 jobFile\n";
    exit 1;
}

$jobFile = shift @ARGV;

unless ( open( JOB, "<$jobFile" )) {
    print "Error: unable to open job file: $jobFile\n";
    exit 1;
}

while ( $URL = <JOB> ) {

    if (( $URL =~ /^#/ ) or ( $URL =~ /^$/ )) {
	 next;
     }
    chomp( $URL );
    if ( $URL =~ s|[a-zA-z]*:/{2}?|| ) {
	$protocol = $&;
	$protocol =~ s|:/{2}?||;
    }
    else {
	$protocol = 'http';
    }
    if ( $URL =~ s|/|| ) {
	$host = $`;
	$doc = "/" . $';
    }
    else {
	$host = $URL;
	if ( $protocol =~ /http/ ) {
	    $doc = '/';
	}
	else {
	    $doc = undef;
	}
    }

    &$protocol( $protocol, $host, $doc );

}

# whois looks up $host on the $whoisHost and reports registrant info.

sub whois {
    my $protocol = shift;
    my $host = shift;

    $port = getservbyname( $protocol, 'tcp' ) or $port = 43;

    unless ( $ipaddr = inet_aton( $whoisHost ) ) {
	print( "Error: ". __FILE__ .":". __LINE__, "\n",
	       "Error: could not resolve whois server address: $whoisHost\n",
	       "Error: $!\n"
	       );
	return 0;
    }

    $paddr = sockaddr_in( $port, $ipaddr );
    $proto   = getprotobyname( 'tcp' );

    unless ( socket( SOCK, PF_INET, SOCK_STREAM, $proto )) {
	print("Error: ". __FILE__ .":". __LINE__, "\n",
	      "Error: could not create network socket\n",
	      "Error: $!\n"
	       );
	return 0;
    }

    unless ( connect( SOCK, $paddr )) {
	report ( "Error: ". __FILE__ .":". __LINE__, "\n",
	       "Error: WebSitter could not connect to whois server: $whoisHost\n",
	       "Error: $!\n"
	       );
	return 0;
    }
    SOCK->autoflush();
# send request to whois server
    print SOCK "$host\n";
    @whois = ();
    while ( defined( $line = <SOCK> )) {
	push @whois, $line;
    }
    close SOCK;
    report( "WebSitter WHOIS: $host",
	   "",
	   @whois
	   );
    return 1;

}

# http opens a connection to remote host and checks to see if the requested
# document is available

sub http {
    my $protocol = shift;
    my $host = shift;
    my $doc = shift;

    
    $port = getservbyname( $protocol, 'tcp' ) or $port = 80;

    unless ( $ipaddr = inet_aton( $host ) ) {
	print( "Error: ". __FILE__ .":". __LINE__, "\n",
	       "Error: could not resolve host address: $host\n",
	       "Error: $!\n"
	       );
	return 0;
    }

    $paddr = sockaddr_in( $port, $ipaddr );
    $proto   = getprotobyname( 'tcp' );

    unless ( socket( SOCK, PF_INET, SOCK_STREAM, $proto )) {
	print("Error: ". __FILE__ .":". __LINE__, "\n",
	      "Error: could not create network socket\n",
	      "Error: $!\n"
	       );
	return 0;
    }

    unless ( connect( SOCK, $paddr )) {
	report( "Error: ". __FILE__ .":". __LINE__, "\n",
	       "Error: WebSitter could not connect to remote host: $host\n",
	       "Error: $!\n"
	       );
	return 0;
    }
    SOCK->autoflush();
# send request to webserver
    @header = ();
    print SOCK "HEAD $protocol://$host$doc HTTP/1.0\n\n";
    while ( defined( $line = <SOCK> )) {
	push @header, $line;
    }
    close SOCK;
    if ( @header[0] =~ /Bad Request/ ){
      # for WebSitePro/2.3.4 which can't handle full URLs
      # we try again with a simpler request packet
	@header = ();
	unless ( socket( SOCK, PF_INET, SOCK_STREAM, $proto )) {
	    print("Error: ". __FILE__ .":". __LINE__, "\n",
		  "Error: could not create network socket\n",
		  "Error: $!\n"
		  );
	    return 0;
	}
	unless ( connect( SOCK, $paddr )) {
	    report( "Error: ". __FILE__ .":". __LINE__, "\n",
		  "Error: WebSitter could not connect to remote host: $host\n",
		  "Error: $!\n"
		  );
	    return 0;
	}
	SOCK->autoflush();
	print SOCK "HEAD $doc HTTP/1.0\n\n";
	while ( defined( $line = <SOCK> )) {
	    push @header, $line;
	}
	close SOCK;
    }

    if ( @header[0] =~ /OK/ ) {
	report( "WebSitter OK: $host$doc\n",
	       "OK $protocol://$host$doc\n", "",
	       @header
	       );
    }
    else {
	report( "WebSitter FAILED: $host$doc\n",
	       "FAILED $protocol://$host$doc\n", "",
	       @header
	       );
    }

    return 1;
}


# the report function takes a subject line and a message body and
# delivers it via $notifier to the recipient.

sub report {

    unless ( open( NOTIFIER, "|$notifier $notifierArgs" ) ) {
	print ("Error: ". __FILE__ .":". __LINE__,
	       "Error: could not open: $notifier"
	       );
	exit 1;
    }

    foreach $line ( @_ ) {
	print NOTIFIER "$line";
    }
    print NOTIFIER "\n\n";
    close NOTIFIER;

}
